/** @file   LightSource.cpp
 * @brief   Implementation of LightSource class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/17 23:06:30 $
 * @author  Tomi Lamminsaari
 */

#include "LightSourceModel.h"
#include "eng2d.h"
#include "www_assert.h"
using namespace eng2d;

namespace WeWantWar {

///
/// LightSourceModel - class.
///
LightSourceModel::LightSourceModel( int aUid ) throw (Exception):
  iUid( aUid )
{
}

LightSourceModel::~LightSourceModel()
{
}

int LightSourceModel::modelUid() const
{
  return iUid;
}



///
/// PointLightModel - class.
///
PointLightModel::PointLightModel( int aUid, int aRadius, const eng2d::Color& aColor )
      throw (Exception) :
  LightSourceModel( aUid ),
  iLightGfx( 0 )
{
  iLightGfx = create_bitmap( 2*aRadius, 2*aRadius );
  if ( iLightGfx == 0 ) {
    throw Exception( "PointLightModel(): Creation failed." );
  }
  clear_bitmap( iLightGfx );

  // Create the light gradient
  int centerX = aRadius;
  int centerY = aRadius;
  Gradient grayScale( aColor, Color(0,0,0) );
  
  for ( int r=aRadius; r > 0; r-- ) {
    Color col;
    grayScale.color( r, 0, aRadius, &col );
    circlefill( iLightGfx, centerX,centerY, r, col.allC() );
  }
}

PointLightModel::~PointLightModel()
{
  if ( iLightGfx != 0 ) {
    destroy_bitmap( iLightGfx );
    iLightGfx = 0;
  }
}

void PointLightModel::redraw( const eng2d::Vec2D& aPosition,
                              BITMAP* aCanvas,
                              int aIntensity )
{
  if ( iLightGfx != 0 ) {
    SetBlendFunction( EAdd, aIntensity );
    int posX = aPosition.intX() - iLightGfx->w/2;
    int posY = aPosition.intY() - iLightGfx->h/2;
    draw_trans_sprite( aCanvas, iLightGfx, posX, posY );
  }
}

};  // end of namespace
